package tcp;
/*
 * DictionaryManager.java
 *
 * Created on October 26, 2004, 3:14 PM
 */

import java.net.*;
import java.io.*;
import java.util.*;
/**
 *
 * @author  garbi
 */
public class DictionaryManager {

    public static void main(String[] args) {
        Socket mySession= null;
        ObjectOutputStream out= null;
        BufferedReader in= null;
        BufferedReader stdIn= null;
        String hostName;
        if (args.length < 1) hostName="localhost";
        else hostName = args[0];
        /*if (args.length < 1) {
            System.out.println("Host name missing");
            System.exit(1);
        }*/
        try {
            mySession = new Socket(hostName, 4449);
            out = new ObjectOutputStream(mySession.getOutputStream());
            in = new BufferedReader(new InputStreamReader(mySession.getInputStream()));
            stdIn = new BufferedReader(new InputStreamReader(System.in));

            System.out.println("Go on, feed the dictionary server!");
            while (true) {
                System.out.print("Word: ");
                String word= stdIn.readLine();
                if ( word.equals("quit") ) break;

                System.out.print("Definition: ");
                String definition= stdIn.readLine();
                if ( definition.equals("quit") ) break;

                
                String[] fromUser= { word , definition };
                
                out.writeObject(fromUser);
                
                String feedback= in.readLine();
                
                System.out.println("-> " + feedback);
                
            }
            
            out.close();
            in.close();
            stdIn.close();
        } catch (UnknownHostException e) {
            System.err.println("Unknown host");
            System.exit(1);
        } catch (IOException e) {
            System.err.println("No server found");
            System.exit(1);
        }
    }
}
